const express = require("express");
const mongoose = require('mongoose');
const bodyParser = require("body-parser");
const flash = require('express-flash-messages') 
User = require('./api/models/user');
Transaction = require('./api/models/transaction')
Cardtransaction = require('./api/models/transaction')
Otp = require('./api/models/otp')
Loans = require('./api/models/transaction')
const session = require('express-session');
const passport = require('passport');
  
const app = express();

app.use('/uploads', express.static("uploads"));
app.use(express.static("public"));

app.use(flash());
app.set('view engine', 'ejs');
app.use(bodyParser.urlencoded({
  extended: true
}));


app.use(session({
  secret: 'harukahn aopoa',
  resave: false,
  saveUninitialized: false
}));

app.use(passport.initialize());
app.use(passport.session());

app.use(function(req, res, next){
  res.locals.user = req.user || null
  next();
});


mongoose.connect('mongodb+srv://fountaincaps:fountaindatabase2020.@cluster0.aiqneha.mongodb.net/?retryWrites=true&w=majority',{
  useNewUrlParser: true,
 useUnifiedTopology : true, 
}).then(() => {
  console.log("Connected af");
}).catch(err => {
  console.log('could not connect: ', err.message);
});


mongoose.set('useFindAndModify', false);

passport.use(User.createStrategy());
passport.serializeUser(User.serializeUser());
passport.deserializeUser(User.deserializeUser());

const routes = require('./api/routes/routes');
routes(app);

let port = process.env.PORT;

if(port == null || port == ""){
    port = 3460;
}


app.listen(port, function(req, res){
    console.log('running smoothly');
});